﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for UserInput.xaml
    /// </summary>
    public partial class SendToKitchen : Window
    {
        public SendToKitchen()
        {
            InitializeComponent();
            List<Layouts> Tables = LayoutBL.GetList(Guid.Empty);
            if (Tables != null && Tables.Count > 0)
            {
                Tables = Tables.Where(a => a.IsActive).ToList<Layouts>();
            }
            ddlTableName.ItemsSource = Tables;
            this.Loaded += new RoutedEventHandler(PromptDialog_Loaded);
        }

        void PromptDialog_Loaded(object sender, RoutedEventArgs e)
        {
            if (ddlTableName.Items != null && AppSession.CurrentOrders.TableNumber != null)
                ddlTableName.SelectedValue = AppSession.CurrentOrders.TableNumber;
            txtResponse.Focus();
        }

        public static string Prompt(string question, string title, string defaultValue = "", InputType inputType = InputType.Text)
        {
            SendToKitchen inst = new SendToKitchen();
            inst.ShowDialog();
            if (inst.DialogResult == true)
                return string.Format("{0} : {1}\n{2} : {3}", "Table", inst.ddlTableName.SelectedValue, "Preference", inst.txtResponse.Text);
            return null;
        }

        public string ResponseText
        {
            get
            {
                return txtResponse.Text;
            }
        }

        private void btnOk_Click(object sender, RoutedEventArgs e)
        {
            DialogResult = true;
            Close();
        }
        private void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            DialogResult = false;
            Close();
        }
    }
}
